/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config.gui;

import com.google.common.collect.ImmutableMap;
import io.github.noeppi_noeppi.libx.LibX;
import io.github.noeppi_noeppi.libx.config.gui.ConfigEditor;
import io.github.noeppi_noeppi.libx.config.gui.WidgetProperties;
import io.github.noeppi_noeppi.libx.impl.config.ConfigImpl;
import io.github.noeppi_noeppi.libx.impl.config.ConfigKey;
import io.github.noeppi_noeppi.libx.impl.config.ConfigState;
import io.github.noeppi_noeppi.libx.impl.config.gui.EditorHelper;
import io.github.noeppi_noeppi.libx.util.CachedValue;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class ConfigDisplay {
    private final ConfigImpl config;
    private final Map<ConfigKey, DisplayValue<?>> values;
    private final CachedValue<ConfigState> cachedState;

    public ConfigDisplay(ConfigImpl config, ConfigState currentState, ConfigState defaultState) {
        this.config = config;
        this.values = new HashMap();
        for (ConfigKey key : config.keys.values()) {
            this.values.put(key, new DisplayValue<Object>(key, key.mapper.createEditor(key.validatorAccess()), currentState.getValue(key), defaultState.getValue(key)));
        }
        this.cachedState = new CachedValue<ConfigState>(this::stateInternal);
    }

    public ConfigState state() {
        return this.cachedState.get();
    }

    private ConfigState stateInternal() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry<ConfigKey, DisplayValue<?>> entry : this.values.entrySet()) {
            Object value = entry.getValue().getValue();
            if (entry.getKey().mapper.type().isAssignableFrom(value.getClass())) {
                map.put((Object)entry.getKey(), value);
                continue;
            }
            LibX.logger.warn("Failed to create config state from user input: Editor produced invalid type. Expected: " + entry.getKey().mapper.type() + ", Got: " + value.getClass() + ", using fallback.");
            map.put((Object)entry.getKey(), entry.getValue().defaultValue);
        }
        return new ConfigState(this.config, (ImmutableMap<ConfigKey, Object>)map.build());
    }

    public AbstractWidget createWidget(ConfigKey key, Screen screen, @Nullable AbstractWidget old, int x, int y, int width, int height) {
        DisplayValue<?> value = this.values.get(key);
        if (value == null) {
            return new AbstractWidget(x, y, width, height, (Component)new TextComponent("DUMMY")){

                public void m_142291_(@Nonnull NarrationElementOutput narration) {
                }
            };
        }
        return EditorHelper.create(screen, value.editor, value.getValue(), old, new WidgetProperties<Object>(x, y, width, height, value::setValue));
    }

    public void save() {
        this.config.applyInGameChanges(this.state());
    }

    private final class DisplayValue<T> {
        public final ConfigKey key;
        public final ConfigEditor<T> editor;
        public final T defaultValue;
        private T value;

        private DisplayValue(ConfigKey key, ConfigEditor<T> editor, T value, T defaultValue) {
            this.key = key;
            this.editor = editor;
            this.defaultValue = defaultValue;
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            if (!this.key.mapper.type().isAssignableFrom(value.getClass())) {
                LibX.logger.warn("Failed to store config value from user input: Editor produced invalid type. Expected: " + this.key.mapper.type() + ", Got: " + value.getClass() + ", ignoring.");
            } else if (this.value != value) {
                this.value = this.key.validate(value, "Invalid value in editor config", null);
                ConfigDisplay.this.cachedState.invalidate();
            }
        }
    }
}

